/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.api.wrapper.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import noppes.npcs.LogWriter;
import noppes.npcs.api.entity.data.IAttributeModifier;
import noppes.npcs.api.entity.data.INpcAttribute;
import noppes.npcs.api.wrapper.data.AttributeModifierWrapper;
import noppes.npcs.reflection.entity.ai.attributes.ModifiableAttributeInstanceReflection;
import noppes.npcs.reflection.entity.ai.attributes.RangedAttributeReflection;
import noppes.npcs.util.ValueUtil;

public class AttributeWrapper
implements INpcAttribute {
    private IAttributeInstance attribute;
    private boolean custom;

    public AttributeWrapper(EntityLivingBase entity, String attributeName, String displayName, double baseValue, double minValue, double maxValue) {
        minValue = ValueUtil.min(minValue, maxValue);
        maxValue = ValueUtil.max(minValue, maxValue);
        RangedAttribute rangedAttribute = new RangedAttribute(null, attributeName, ValueUtil.correctDouble(baseValue, minValue, maxValue), minValue, maxValue);
        rangedAttribute.func_111117_a(displayName);
        try {
            this.attribute = new ModifiableAttributeInstance(entity.func_110140_aT(), (IAttribute)rangedAttribute);
        }
        catch (Exception e) {
            this.attribute = null;
        }
        this.custom = true;
    }

    public AttributeWrapper(IAttributeInstance mcAttribute) {
        this.attribute = mcAttribute;
        this.custom = false;
        String name = this.getName();
        if (!(name.equals("generic.maxHealth") || name.equals("generic.knockbackResistance") || name.equals("generic.movementSpeed") || name.equals("generic.armor") || name.equals("generic.armorToughness") || name.equals("generic.attackDamage") || name.equals("generic.attackSpeed") || name.equals("generic.luck") || name.equals("generic.reachDistance") || name.equals("forge.swimSpeed"))) {
            this.custom = true;
        }
    }

    @Override
    public IAttributeModifier addModifier(IAttributeModifier modifier) {
        if (this.hasModifier(modifier)) {
            return null;
        }
        this.attribute.func_111121_a(modifier.getMCModifier());
        return this.getModifier(modifier.getID());
    }

    @Override
    public IAttributeModifier addModifier(String modifierName, double amount, int operation) {
        if (modifierName == null || modifierName.isEmpty() || this.hasModifier(modifierName)) {
            return null;
        }
        AttributeModifier modifier = new AttributeModifier(modifierName, amount, operation);
        this.attribute.func_111121_a(modifier);
        return this.getModifier(modifierName);
    }

    @Override
    public double getBaseValue() {
        return this.attribute.func_111125_b();
    }

    @Override
    public String getDisplayName() {
        IAttributeInstance attribute = this.attribute;
        if (this.attribute instanceof ModifiableAttributeInstance) {
            attribute = ModifiableAttributeInstanceReflection.getGenericAttribute((ModifiableAttributeInstance)attribute);
        }
        if (attribute instanceof RangedAttribute) {
            return ((RangedAttribute)attribute).func_111116_f();
        }
        return null;
    }

    @Override
    public double getMaxValue() {
        IAttributeInstance attribute = this.attribute;
        if (this.attribute instanceof ModifiableAttributeInstance) {
            attribute = ModifiableAttributeInstanceReflection.getGenericAttribute((ModifiableAttributeInstance)attribute);
        }
        if (attribute instanceof RangedAttribute) {
            return RangedAttributeReflection.getMaxValue((RangedAttribute)attribute);
        }
        return 0.0;
    }

    @Override
    public IAttributeInstance getMCAttribute() {
        return this.attribute;
    }

    @Override
    public IAttribute getMCBaseAttribute() {
        if (this.attribute instanceof ModifiableAttributeInstance) {
            return ModifiableAttributeInstanceReflection.getGenericAttribute((ModifiableAttributeInstance)this.attribute);
        }
        return null;
    }

    @Override
    public double getMinValue() {
        IAttributeInstance attribute = this.attribute;
        if (this.attribute instanceof ModifiableAttributeInstance) {
            attribute = ModifiableAttributeInstanceReflection.getGenericAttribute((ModifiableAttributeInstance)attribute);
        }
        if (attribute instanceof RangedAttribute) {
            return RangedAttributeReflection.getMinValue((RangedAttribute)attribute);
        }
        return 0.0;
    }

    @Override
    public IAttributeModifier getModifier(String uuidOrName) {
        if (uuidOrName == null || uuidOrName.isEmpty()) {
            return null;
        }
        AttributeModifier modifier = null;
        try {
            UUID uuid = UUID.fromString(uuidOrName);
            modifier = this.attribute.func_111127_a(uuid);
        }
        catch (Exception e) {
            LogWriter.error(e);
        }
        if (modifier == null) {
            for (AttributeModifier am : this.attribute.func_111122_c()) {
                if (!am.func_111166_b().equals(uuidOrName)) continue;
                modifier = am;
                break;
            }
        }
        if (modifier != null) {
            return new AttributeModifierWrapper(this, modifier);
        }
        return null;
    }

    @Override
    public IAttributeModifier[] getModifiers() {
        Collection col = this.attribute.func_111122_c();
        IAttributeModifier[] modifiers = new IAttributeModifier[col.size()];
        int i = 0;
        for (AttributeModifier am : col) {
            modifiers[i] = new AttributeModifierWrapper(this, am);
            ++i;
        }
        return modifiers;
    }

    @Override
    public IAttributeModifier[] getModifiersByOperation(int operation) {
        Collection col = this.attribute.func_111130_a(operation);
        IAttributeModifier[] modifiers = new IAttributeModifier[col.size()];
        int i = 0;
        for (AttributeModifier am : col) {
            modifiers[i] = new AttributeModifierWrapper(this, am);
            ++i;
        }
        return modifiers;
    }

    @Override
    public String getName() {
        if (this.attribute instanceof IAttribute) {
            return ((IAttribute)this.attribute).func_111108_a();
        }
        if (this.attribute instanceof ModifiableAttributeInstance) {
            return this.attribute.func_111123_a().func_111108_a();
        }
        return null;
    }

    @Override
    public double getTotalValue() {
        return this.attribute.func_111126_e();
    }

    @Override
    public boolean hasModifier(IAttributeModifier modifier) {
        if (modifier == null) {
            return false;
        }
        boolean has = this.attribute.func_180374_a(modifier.getMCModifier());
        if (has) {
            return true;
        }
        for (AttributeModifier am : this.attribute.func_111122_c()) {
            if (!am.func_111167_a().equals(modifier.getMCModifier().func_111167_a())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasModifier(String uuidOrName) {
        if (uuidOrName == null || uuidOrName.isEmpty()) {
            return false;
        }
        boolean has = false;
        try {
            UUID uuid = UUID.fromString(uuidOrName);
            has = this.attribute.func_111127_a(uuid) != null;
        }
        catch (Exception e) {
            LogWriter.error(e);
        }
        if (has) {
            return true;
        }
        for (AttributeModifier am : this.attribute.func_111122_c()) {
            if (!am.func_111166_b().equals(uuidOrName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isCustom() {
        return this.custom;
    }

    @Override
    public void removeAllModifiers() {
        ArrayList list = new ArrayList(this.attribute.func_111122_c());
        for (AttributeModifier am : list) {
            this.attribute.func_111124_b(am);
        }
    }

    @Override
    public boolean removeModifier(IAttributeModifier modifier) {
        if (modifier == null) {
            return false;
        }
        if (this.hasModifier(modifier)) {
            this.attribute.func_111124_b(modifier.getMCModifier());
            boolean has = this.hasModifier(modifier);
            if (!has) {
                return true;
            }
            for (AttributeModifier am : this.attribute.func_111122_c()) {
                if (!am.func_111167_a().equals(modifier.getMCModifier().func_111167_a())) continue;
                this.attribute.func_111124_b(am);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean removeModifier(String uuid) {
        return this.removeModifier(this.getModifier(uuid));
    }

    @Override
    public void setBaseValue(double baseValue) {
        this.attribute.func_111128_a(baseValue);
    }

    @Override
    public void setDisplayName(String displayName) {
        IAttributeInstance attribute = this.attribute;
        if (this.attribute instanceof ModifiableAttributeInstance) {
            attribute = ModifiableAttributeInstanceReflection.getGenericAttribute((ModifiableAttributeInstance)attribute);
        }
        if (attribute instanceof RangedAttribute) {
            ((RangedAttribute)attribute).func_111117_a(displayName);
        }
    }

    @Override
    public void setMaxValue(double maxValue) {
        IAttributeInstance attribute = this.attribute;
        if (this.attribute instanceof ModifiableAttributeInstance) {
            attribute = ModifiableAttributeInstanceReflection.getGenericAttribute((ModifiableAttributeInstance)attribute);
        }
        if (attribute instanceof RangedAttribute) {
            double minValue = RangedAttributeReflection.getMinValue((RangedAttribute)attribute);
            minValue = ValueUtil.min(minValue, maxValue);
            maxValue = ValueUtil.max(minValue, maxValue);
            RangedAttributeReflection.setMinValue((RangedAttribute)attribute, minValue);
            RangedAttributeReflection.setMaxValue((RangedAttribute)attribute, maxValue);
        }
    }

    @Override
    public void setMinValue(double minValue) {
        IAttributeInstance attribute = this.attribute;
        if (this.attribute instanceof ModifiableAttributeInstance) {
            attribute = ModifiableAttributeInstanceReflection.getGenericAttribute((ModifiableAttributeInstance)attribute);
        }
        if (attribute instanceof RangedAttribute) {
            double maxValue = RangedAttributeReflection.getMaxValue((RangedAttribute)attribute);
            minValue = ValueUtil.min(minValue, maxValue);
            maxValue = ValueUtil.max(minValue, maxValue);
            RangedAttributeReflection.setMinValue((RangedAttribute)attribute, minValue);
            RangedAttributeReflection.setMaxValue((RangedAttribute)attribute, maxValue);
        }
    }

    public void setCustom(boolean bo) {
        this.custom = bo;
    }
}

